using System;
using System.Drawing;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX;
namespace win
{
    #region home class
    class home
    {
        private Mesh mesh_build2;
        private Mesh mesh_build1;
        private Mesh mesh_grand;
        private Texture[] texture_build1;
        private Texture[] texture_build2;
        private Texture[] texture_grand;
        private Material[] material_build1;
        private ExtendedMaterial[] materialarray_build1;
        private Material[] material_build2;
        private ExtendedMaterial[] materialarray_build2;
        private Material[] material_grand;
        private ExtendedMaterial[] materialarray_grand;
        #region mesh desinger
       
        #region loading mesh
        public void loading_mesh(Device device)
        {
            //loading first build
            mesh_build1 = Mesh.FromFile(Environment.CurrentDirectory+@"\Building_High1\building_high1.x", MeshFlags.Managed, device, out materialarray_build1);
            texture_build1 = new Texture[materialarray_build1.Length];
            material_build1 = new Material[materialarray_build1.Length];
            //loading second build
            mesh_build2 = Mesh.FromFile(Environment.CurrentDirectory + @"\Building_Detailed1\building_detailed1.x", MeshFlags.Managed, device, out materialarray_build2);
            texture_build2 = new Texture[materialarray_build2.Length];
            material_build2 = new Material[materialarray_build2.Length];
            //loading grand
            mesh_grand = Mesh.FromFile(Environment.CurrentDirectory + @"\Path_Strasse\floor_asphalt.x", MeshFlags.Managed, device, out materialarray_grand);
            texture_grand = new Texture[materialarray_grand.Length];
            material_grand = new Material[materialarray_grand.Length];
            //initialize mesh
            initialize_mesh(device);
            //initialize lights
            initialize_lights(device);
        }
        #endregion
       
        #region initialize mesh
        private void initialize_mesh(Device device)
        {
            //initialize first build
            for (int count = 0; count < materialarray_build1.Length; count++)
            {
                material_build1[count].Ambient = material_build1[count].Diffuse;
                material_build1[count] =materialarray_build1[count].Material3D;
                texture_build1[count] = TextureLoader.FromFile(device, Environment.CurrentDirectory + @"\Building_High1\" + materialarray_build1[count].TextureFilename);
            }
            //initialize first build
            for (int count = 0; count < materialarray_build2.Length; count++)
            {
               material_build2[count].Ambient = material_build2[count].Diffuse;
               material_build2[count] = materialarray_build2[count].Material3D;
               texture_build2[count] = TextureLoader.FromFile(device, Environment.CurrentDirectory + @"\Building_Detailed1\" + materialarray_build2[count].TextureFilename);
            }
            //initialize grand
            for (int count = 0; count < materialarray_grand.Length; count++)
            {
                material_grand[count].Ambient = material_grand[count].Diffuse;
                material_grand[count] = materialarray_grand[count].Material3D;
                texture_grand[count] = TextureLoader.FromFile(device, Environment.CurrentDirectory + @"\Path_Strasse\" + materialarray_grand[count].TextureFilename);
            }
        }
        #endregion
        
        #region initialize lights
        private void initialize_lights(Device device)
        {
            device.Lights[0].Type = LightType.Directional;
            device.Lights[0].Diffuse = Color.White;
            device.Lights[0].Direction = new Vector3(1, 1, -1);
            device.Lights[0].Update();
            device.Lights[0].Enabled = true;
            device.Lights[1].Type = LightType.Directional;
            device.Lights[1].Diffuse = Color.White;
            device.Lights[1].Direction = new Vector3(-1, -1, -1);
            device.Lights[1].Update();
            device.Lights[2].Enabled = true;
            device.Lights[2].Type = LightType.Directional;
            device.Lights[2].Diffuse = Color.White;
            device.Lights[2].Direction = new Vector3(-3, -4, -5);
            device.Lights[2].Update();
            device.Lights[2].Enabled = true;
        }
        #endregion
        
        #region  draw mesh
        public void mesh_draw(Device device,float x,float y, Vector3 pos)
        {
            device.Transform.World = Matrix.Scaling(0.1f, 0.1f, 0.1f) * Matrix.Translation(pos) * Matrix.RotationY(y)*Matrix.RotationX(x); 
            for (int count = 0; count < materialarray_build1.Length; count++)
            {
                device.Material = material_build1[count];
                device.SetTexture(0, texture_build1[count]);
                mesh_build1.DrawSubset(count);
            }
            device.Transform.World = Matrix.Scaling(0.2f, 0.2f, 0.2f) * Matrix.Translation(new Vector3(-150, 0, -200))*Matrix.Translation(pos)*Matrix.RotationY(y)*Matrix.RotationX(x);
            for (int count = 0; count < materialarray_build2.Length; count++)
            {
                device.Material = material_build2[count];
                device.SetTexture(0, texture_build2[count]);
                mesh_build2.DrawSubset(count);
            }
            device.Transform.World = Matrix.Scaling(2f, 2f, 2f) * Matrix.Translation(new Vector3(0, 0, 0)) * Matrix.Translation(pos) * Matrix.RotationY(y)*Matrix.RotationX(x);
            for (int count = 0; count < 1; count++)
            {
                device.Material = material_grand[count];
                device.SetTexture(0, texture_grand[count]);
                mesh_grand.DrawSubset(count);
            }
        }
        #endregion
        
        #endregion
    }
    #endregion
}
